
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_IssuedUnit : BaseTest 
	{
		private Guid _bloodUnitGuid;
		private Guid _issuedUnitGuid;
		private Guid _patientGuid;
		private byte[] _unitStatusRowVersion;
		private byte[] _issuedUnitRowVersion;
		private BOL.IssuedUnit _issuedUnit;
		private Guid _bloodUnitStatusGuid;

		private string orderedUnitQuery = "SELECT TOP 1 OU.OrderedUnitGuid, OU.RowVersion, VW.UnitStatusRowVersion FROM OrderedUnit OU " +
			"JOIN vw_BloodShipAllCurrent VW ON OU.BloodUnitGUID = VW.BloodUnitGUID WHERE VW.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'";

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			
			// build the sql query string
			string sSQL = "SELECT TOP 1 VW.BloodUnitStatusGuid, IU.BloodUnitGuid, IU.IssuedUnitGuid, IU.RowVersion, PT.PatientGuid, VW.UnitStatusRowVersion FROM IssuedUnit IU " +
							"JOIN OrderedUnit OU on IU.BloodUnitGUID = OU.BloodUnitGUID " +
							"JOIN OrderedComponent OC on OU.OrderedComponentGUID = OC.OrderedComponentGUID " +
							"JOIN PatientOrder PO on OC.PatientOrderGUID = PO.PatientOrderGUID " +
							"JOIN PatientTreatment PT on PO.PatientTreatmentGUID = PT.PatientTreatmentGUID " +
							"JOIN vw_BloodShipAllCurrent VW ON IU.BloodUnitGuid = VW.BloodUnitGuid WHERE " +
							"VW.DivisionCode = '" + this.TestDivisionCode + 
							"' AND VW.UnitStatusCode = 'I' " + 
							"AND IU.ReturnDateTime IS NULL " + 
							"AND OU.ReleaseTechId IS NULL " +
							"AND OU.RecordStatusCode = 'A'";

			if (this.RefreshData)
			{
				DataCreator.CreateIssuedBloodUnit(false);

				// instantiate the Connection and Command object
				DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);

				_bloodUnitGuid	= (Guid) dtTemp.Rows[0][TABLES.IssuedUnit.BloodUnitGuid];
				_bloodUnitStatusGuid	= (Guid) dtTemp.Rows[0][TABLES.BloodUnitStatus.BloodUnitStatusGuid];
				_issuedUnitGuid = (Guid) dtTemp.Rows[0][TABLES.IssuedUnit.IssuedUnitGuid];
				_patientGuid	= (Guid) dtTemp.Rows[0][TABLES.Patient.PatientGuid];
				_issuedUnitRowVersion = (byte[]) dtTemp.Rows[0][TABLES.IssuedUnit.RowVersion];
				_unitStatusRowVersion = (byte[]) dtTemp.Rows[0][ARTIFICIAL.UnitStatusRowVersion];

				this.RefreshData = false;
			}

			//Create new Issued Unit
			this._issuedUnit = new BOL.IssuedUnit(_issuedUnitGuid);
		}

		[Test]
		public void GetIssuedUnit_Pass()
		{
			DataTable dtTest = DAL.IssuedUnit.GetIssuedUnit(_issuedUnitGuid);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(19, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssuedUnitGuid), TABLES.IssuedUnit.IssuedUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.BloodUnitGuid), TABLES.IssuedUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueDateTime), TABLES.IssuedUnit.IssueDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueTechId), TABLES.IssuedUnit.IssueTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.PhysicianName), TABLES.IssuedUnit.PhysicianName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.TransporterName), TABLES.IssuedUnit.TransporterName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueToLocationName), TABLES.IssuedUnit.IssueToLocationName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.InPatientLocationIndicator), TABLES.IssuedUnit.InPatientLocationIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueSatisfactoryIndicator), TABLES.IssuedUnit.IssueSatisfactoryIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.RemoteStorageIndicator), TABLES.IssuedUnit.RemoteStorageIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.RemoteStorageText), TABLES.IssuedUnit.RemoteStorageText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnDateTime), TABLES.IssuedUnit.ReturnDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnTechId), TABLES.IssuedUnit.ReturnTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnFromLocationName), TABLES.IssuedUnit.ReturnFromLocationName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnSatisfactoryIndicator), TABLES.IssuedUnit.ReturnSatisfactoryIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.LastUpdateDate), TABLES.IssuedUnit.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.LastUpdateUser), TABLES.IssuedUnit.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.LocationIen), TABLES.IssuedUnit.LocationIen);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.RowVersion), TABLES.IssuedUnit.RowVersion);
		}

		[Test]
		public void GetIssuedUnit_Fail()
		{
			DataTable dtTest = DAL.IssuedUnit.GetIssuedUnit(Guid.Empty);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		public void GetRemoteStorageLocations_Pass()
		{
			System.Collections.ArrayList alTest = DAL.IssuedUnit.GetRemoteStorageLocations();

			Assert.AreEqual(true, alTest.Count > 0, "ArrayList.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRemoteStorageLocations_Fail()
		{
		}


		[Test]
		public void GetIssuedUnitByBloodUnitGuid_Pass()
		{
			DataTable dtTest = DAL.IssuedUnit.GetIssuedUnitByBloodUnitGuid(_bloodUnitGuid);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(45, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssuedUnitGuid), TABLES.IssuedUnit.IssuedUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueDateTime), TABLES.IssuedUnit.IssueDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueTechId), TABLES.IssuedUnit.IssueTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.PhysicianName), TABLES.IssuedUnit.PhysicianName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.TransporterName), TABLES.IssuedUnit.TransporterName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueToLocationName), TABLES.IssuedUnit.IssueToLocationName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.InPatientLocationIndicator), TABLES.IssuedUnit.InPatientLocationIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueSatisfactoryIndicator), TABLES.IssuedUnit.IssueSatisfactoryIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.RemoteStorageIndicator), TABLES.IssuedUnit.RemoteStorageIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.RemoteStorageText), TABLES.IssuedUnit.RemoteStorageText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnDateTime), TABLES.IssuedUnit.ReturnDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnTechId), TABLES.IssuedUnit.ReturnTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnFromLocationName), TABLES.IssuedUnit.ReturnFromLocationName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnSatisfactoryIndicator), TABLES.IssuedUnit.ReturnSatisfactoryIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.RowVersion), TABLES.IssuedUnit.RowVersion);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.BloodUnitGuid), TABLES.IssuedUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientGuid), TABLES.Patient.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenExpirationDate), TABLES.PatientSpecimen.SpecimenExpirationDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedUnitGuid), TABLES.OrderedUnit.OrderedUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.OrderedUnitRowVersion), ARTIFICIAL.OrderedUnitRowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BloodUnitStatusGuid), TABLES.BloodUnitStatus.BloodUnitStatusGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);

		}

		[Test]
		public void GetIssuedUnitByBloodUnitGuid_Fail()
		{
			DataTable dtTest = DAL.IssuedUnit.GetIssuedUnitByBloodUnitGuid(Guid.Empty);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetIssuedUnitsForPatient_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//
			Guid bloodUnitGuid = Guid.NewGuid();
			//
			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);
			DataTable dtUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE BloodunitGuid = '"+ bloodUnitGuid.ToString()+"'");
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedUnitGuid = Guid.NewGuid();
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "1,";
			insertOrderedUnit += "'C',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			string insertBloodUnitTest1 = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest1 += "VALUES (";
			insertBloodUnitTest1 += "'" + bloodUnitTestGuid1.ToString() + "',";
			insertBloodUnitTest1 += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest1 += "'100',";
			insertBloodUnitTest1 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'0',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'M',";
			insertBloodUnitTest1 += "'" + orderedComponentGuid.ToString() + "',";
			insertBloodUnitTest1 += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest1 += "'2',";
			insertBloodUnitTest1 += "'A',";
			insertBloodUnitTest1 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest1 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			string insertBloodUnitTest2 = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest2 += "VALUES (";
			insertBloodUnitTest2 += "'" + bloodUnitTestGuid2.ToString() + "',";
			insertBloodUnitTest2 += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest2 += "'102',";
			insertBloodUnitTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'C',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'M',";
			insertBloodUnitTest2 += "'" + orderedComponentGuid.ToString() + "',";
			insertBloodUnitTest2 += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest2 += "'2',";
			insertBloodUnitTest2 += "'A',";
			insertBloodUnitTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid issuedUnitGuid = Guid.NewGuid();
			string insertIssuedUnit = "INSERT INTO ISSUEDUNIT (";
			insertIssuedUnit += TABLES.IssuedUnit.IssuedUnitGuid + ",";
			insertIssuedUnit += TABLES.IssuedUnit.BloodUnitGuid + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueDateTime + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueTechId + ",";
			insertIssuedUnit += TABLES.IssuedUnit.TransporterName + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueToLocationName + ",";
			insertIssuedUnit += TABLES.IssuedUnit.InPatientLocationIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueSatisfactoryIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.RemoteStorageIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateDate + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateUser + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateFunctionId + ")";
			insertIssuedUnit += "VALUES (";
			insertIssuedUnit += "'" + issuedUnitGuid.ToString() + "',";
			insertIssuedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'10W P-KC',";
			insertIssuedUnit += "0,";
			insertIssuedUnit += "1,";
			insertIssuedUnit += "0,";
			insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertOrderedUnit);
			UnitTestUtil.RunSQL(insertBloodUnitTest1);
			UnitTestUtil.RunSQL(insertBloodUnitTest2);
			UnitTestUtil.RunSQL(insertIssuedUnit);

			DataTable dtTest = DAL.IssuedUnit.GetIssuedUnitsForPatient(patientGuid);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(46, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssuedUnitGuid), TABLES.IssuedUnit.IssuedUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.BloodUnitGuid), TABLES.IssuedUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueDateTime), TABLES.IssuedUnit.IssueDateTime);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueTechId), TABLES.IssuedUnit.IssueTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.PhysicianName), TABLES.IssuedUnit.PhysicianName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.TransporterName), TABLES.IssuedUnit.TransporterName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueToLocationName), TABLES.IssuedUnit.IssueToLocationName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.InPatientLocationIndicator), TABLES.IssuedUnit.InPatientLocationIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueSatisfactoryIndicator), TABLES.IssuedUnit.IssueSatisfactoryIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.RemoteStorageIndicator), TABLES.IssuedUnit.RemoteStorageIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.RemoteStorageText), TABLES.IssuedUnit.RemoteStorageText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnDateTime), TABLES.IssuedUnit.ReturnDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnTechId), TABLES.IssuedUnit.ReturnTechId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnFromLocationName), TABLES.IssuedUnit.ReturnFromLocationName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnSatisfactoryIndicator), TABLES.IssuedUnit.ReturnSatisfactoryIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.RowVersion), TABLES.IssuedUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientGuid), TABLES.Patient.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenExpirationDate), TABLES.PatientSpecimen.SpecimenExpirationDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedUnitGuid), TABLES.OrderedUnit.OrderedUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.ReleaseDate), TABLES.OrderedUnit.ReleaseDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.OrderedUnitRowVersion), ARTIFICIAL.OrderedUnitRowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BloodUnitStatusGuid), TABLES.BloodUnitStatus.BloodUnitStatusGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);

		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetIssuedUnitsForPatient_Fail()
		{
			DAL.IssuedUnit.GetIssuedUnitsForPatient(Guid.Empty);
		}

		[Test]
		public void GetIssuedUnits_Pass()
		{
			DataTable dtTest = DAL.IssuedUnit.GetIssuedUnits();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(55, dtTest.Columns.Count, "Columns.Count");
		
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.BloodUnitGuid), TABLES.IssuedUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssuedUnitGuid), TABLES.IssuedUnit.IssuedUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueTechId), TABLES.IssuedUnit.IssueTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.PhysicianName), TABLES.IssuedUnit.PhysicianName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.TransporterName), TABLES.IssuedUnit.TransporterName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueToLocationName), TABLES.IssuedUnit.IssueToLocationName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.InPatientLocationIndicator), TABLES.IssuedUnit.InPatientLocationIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueSatisfactoryIndicator), TABLES.IssuedUnit.IssueSatisfactoryIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.RemoteStorageIndicator), TABLES.IssuedUnit.RemoteStorageIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.RemoteStorageText), TABLES.IssuedUnit.RemoteStorageText);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnDateTime), TABLES.IssuedUnit.ReturnDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnTechId), TABLES.IssuedUnit.ReturnTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnFromLocationName), TABLES.IssuedUnit.ReturnFromLocationName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.ReturnSatisfactoryIndicator), TABLES.IssuedUnit.ReturnSatisfactoryIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.RowVersion), TABLES.IssuedUnit.RowVersion);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetIssuedUnits_Fail()
		{
		}

		[Test]
		public void InsertIssuedUnits_Pass()
		{
			DataTable dtIssuedUnits = SprocHelper.GetInsertIssuedUnitSprocTable(System.Guid.NewGuid(), this._bloodUnitGuid, this._patientGuid);
			DataTable dtUpdBUS = DAL.BloodUnitStatus.GetEmptyBloodUnitStatusTableSchema(true);
			
			BOL.BloodUnitStatus tmpBUS = new BOL.BloodUnitStatus(this._bloodUnitGuid);
			dtUpdBUS.Rows.Add(tmpBUS.LoadDataRowFromThis(dtUpdBUS.NewRow()));
			Common.Utility.AppendLastUpdateInformation(dtUpdBUS, Common.UpdateFunction.UnitTests);

			bool retValue = DAL.IssuedUnit.InsertIssuedUnits(dtIssuedUnits, null, dtUpdBUS , null, null, null, null,null);

			Assert.AreEqual(true, retValue, "ReturnValue"); 
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void InsertIssuedUnits_Fail()
		{
			DataTable dtIssuedUnits = SprocHelper.GetInsertIssuedUnitSprocTable(System.Guid.NewGuid(), this._bloodUnitGuid, this._patientGuid);
			DataTable dtUpdBUS = DAL.BloodUnitStatus.GetEmptyBloodUnitStatusTableSchema(true);
			
			BOL.BloodUnitStatus tmpBUS = new BOL.BloodUnitStatus(this._bloodUnitGuid);
			dtUpdBUS.Rows.Add(tmpBUS.LoadDataRowFromThis(dtUpdBUS.NewRow()));
			Common.Utility.AppendLastUpdateInformation(dtUpdBUS, Common.UpdateFunction.UnitTests);

			dtUpdBUS.Rows[0][TABLES.BloodUnitStatus.RowVersion] = new byte[8];

			DAL.IssuedUnit.InsertIssuedUnits(dtIssuedUnits, null, dtUpdBUS, null, null, null, null,null);
		}

		[Test]
		public void MarkUnitUnsatisfactory_Pass()
		{
			this.RefreshData = true;

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(orderedUnitQuery, true); 

			Guid orderedUnitGuid		= (Guid) dtTemp.Rows[0]["OrderedUnitGuid"];
			byte[] rowVersion			= (byte[]) dtTemp.Rows[0]["RowVersion"];
			byte[] unitStatusRowVersion	= (byte[]) dtTemp.Rows[0]["UnitStatusRowVersion"];
			
			bool retValue = DAL.IssuedUnit.MarkUnitUnsatisfactory(orderedUnitGuid, rowVersion, unitStatusRowVersion, Common.UpdateFunction.UnitTests,null);

			Assert.AreEqual(true, retValue, "ReturnValue");
	
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void MarkUnitUnsatisfactory_Fail()
		{
			DAL.IssuedUnit.MarkUnitUnsatisfactory(Guid.Empty, null, null, Common.UpdateFunction.UnitTests,null);
		}

		[Test]
		public void MarkUnitUnsatisfactory_DataTables_Pass()
		{
			this.RefreshData = true;
			
			DataTable dtTempOU = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
			System.Guid ouGuid = (System.Guid)dtTempOU.Rows[0][TABLES.OrderedUnit.OrderedUnitGuid];
			byte[] ouRowVersion = (byte[])dtTempOU.Rows[0][TABLES.OrderedUnit.RowVersion];

			DataTable dtUpdIU = SprocHelper.GetUpdateIssuedUnitSprocTable(this._issuedUnitGuid, this._issuedUnitRowVersion);
			DataTable dtUpdBUS = SprocHelper.GetUpdateBloodUnitStatusSprocTable(this._bloodUnitStatusGuid, this._unitStatusRowVersion,false);
			DataTable dtRelease = SprocHelper.GetReleaseOrderedUnitsSprocTable(ouGuid, ouRowVersion);
			DataTable dtExc = new DataTable(); //InsertExceptionReturnIssuedUnit
			DataTable dtInsWE = new DataTable();  //InsertWorkloadEvent
	
			bool retValue = DAL.IssuedUnit.MarkUnitUnsatisfactory(dtUpdIU, dtUpdBUS, dtRelease, dtExc, dtInsWE,null);

			Assert.AreEqual(true, retValue, "RetunValue");

			//Rollback 
			UnitTestUtil.RunSQL("UPDATE OrderedUnit SET ReleaseDate = null, ReleaseTechId = null WHERE OrderedUnitGuid = '" + ouGuid.ToString() + "'");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void MarkUnitUnsatisfactory_DataTables_Fail()
		{
			this.RefreshData = true;
			
			DataTable dtTempOU = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
			System.Guid ouGuid = (System.Guid)dtTempOU.Rows[0][TABLES.OrderedUnit.OrderedUnitGuid];
			byte[] ouRowVersion = new byte[8];

			DataTable dtUpdIU = SprocHelper.GetUpdateIssuedUnitSprocTable(this._issuedUnitGuid, new byte[8]);
			DataTable dtUpdBUS = SprocHelper.GetUpdateBloodUnitStatusSprocTable(this._bloodUnitStatusGuid, new byte[8],false);
			DataTable dtRelease = SprocHelper.GetReleaseOrderedUnitsSprocTable(ouGuid, ouRowVersion);
			DataTable dtExc = new DataTable(); //InsertExceptionReturnIssuedUnit
			DataTable dtInsWE = new DataTable();  //InsertWorkloadEvent
	
			DAL.IssuedUnit.MarkUnitUnsatisfactory(dtUpdIU, dtUpdBUS, dtRelease, dtExc, dtInsWE,null);

		}

		[Test]
		public void Update_Pass()
		{
			this.RefreshData = true;

			DataSet dsSave = new DataSet();

			// Create DataTable for return unit
			DataTable dtReturnIssuedUnits = new DataTable(TABLES.IssuedUnit.TableName);
			dtReturnIssuedUnits.Columns.Add(TABLES.IssuedUnit.IssuedUnitGuid, typeof(Guid));
			dtReturnIssuedUnits.Columns.Add(TABLES.IssuedUnit.ReturnDateTime, typeof(DateTime));
			dtReturnIssuedUnits.Columns.Add(TABLES.IssuedUnit.ReturnTechId, typeof(string));
			dtReturnIssuedUnits.Columns.Add(TABLES.IssuedUnit.ReturnFromLocationName, typeof(string));
			dtReturnIssuedUnits.Columns.Add(TABLES.IssuedUnit.ReturnSatisfactoryIndicator, typeof(bool));
			dtReturnIssuedUnits.Columns.Add(TABLES.IssuedUnit.LastUpdateUser, typeof(string));
			dtReturnIssuedUnits.Columns.Add(TABLES.IssuedUnit.LastUpdateFunctionId, typeof(int));
			dtReturnIssuedUnits.Columns.Add(TABLES.BloodUnit.DivisionCode, typeof(string));
			dtReturnIssuedUnits.Columns.Add(TABLES.IssuedUnit.RowVersion, typeof(byte[]));

			//Create DataTable for ordered units that need to be released from assignment
			DataTable dtOrderedUnit = new DataTable(TABLES.OrderedUnit.TableName);
			dtOrderedUnit.Columns.Add(TABLES.OrderedUnit.OrderedUnitGuid, typeof(Guid));
			dtOrderedUnit.Columns.Add(TABLES.OrderedUnit.ReleaseTechId, typeof(string));
			dtOrderedUnit.Columns.Add(TABLES.OrderedUnit.ReleaseDate, typeof(DateTime));
			dtOrderedUnit.Columns.Add(TABLES.OrderedUnit.LastUpdateUser, typeof(string));
			dtOrderedUnit.Columns.Add(TABLES.OrderedUnit.RowVersion, typeof(byte[]));
			dtOrderedUnit.Columns.Add(TABLES.OrderedUnit.LastUpdateFunctionId, typeof(int));
			dtOrderedUnit.Columns.Add(TABLES.OrderedUnit.DivisionCode, typeof(string));
			
			//Add return unit info to the table
			DataRow drReturnIssuedUnits = dtReturnIssuedUnits.NewRow();
			drReturnIssuedUnits[TABLES.IssuedUnit.IssuedUnitGuid] = (Guid) _issuedUnit.IssuedUnitGuid;
			drReturnIssuedUnits[TABLES.IssuedUnit.ReturnDateTime] = System.DateTime.Now;
			drReturnIssuedUnits[TABLES.IssuedUnit.ReturnTechId] = _issuedUnit.ReturnTechId;
			drReturnIssuedUnits[TABLES.IssuedUnit.ReturnFromLocationName]= _issuedUnit.ReturnFromLocationName;
			drReturnIssuedUnits[TABLES.IssuedUnit.ReturnSatisfactoryIndicator] = true;
			drReturnIssuedUnits[TABLES.IssuedUnit.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drReturnIssuedUnits[TABLES.IssuedUnit.LastUpdateFunctionId] = Common.UpdateFunction.UnitTests;
			drReturnIssuedUnits[TABLES.IssuedUnit.RowVersion] = (byte[]) _issuedUnit.RowVersion;
			drReturnIssuedUnits[TABLES.BloodUnit.DivisionCode] = this.TestDivisionCode;
			dtReturnIssuedUnits.Rows.Add(drReturnIssuedUnits);

			DataTable dtBloodUnitStatus = DAL.BloodUnitStatus.GetEmptyBloodUnitStatusTableSchema(true);
			//Crete an instance of the blood unit object, so I can get the rowversion for update the record
			BOL.BloodUnitStatus tempBloodUnitStatus = new BOL.BloodUnitStatus((Guid) _issuedUnit.BloodUnitGuid);
			DataRow drBloodUnitStatus = tempBloodUnitStatus.LoadDataRowFromThis(dtBloodUnitStatus.NewRow());

			//Get the previous status of the blood unit first; BR_59.11
			//Add tables to dsSave dataset
			dsSave.Tables.Add(dtReturnIssuedUnits);

			//Create an exception
			DataTable dtERU = DAL.ExceptionReport.GetExceptionReportReturnIssuedUnit(this._issuedUnit.BloodUnitGuid).Tables[0].Copy();
			dtERU.TableName = TABLES.ExceptionReturnedUnit.TableName;
			dsSave.Tables.Add(dtERU);

			bool retValue = DAL.IssuedUnit.Update(dsSave, Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		public void Update_Fail()
		{
			try
			{
				bool success = DAL.IssuedUnit.Update(new DataSet(), Common.UpdateFunction.UnitTests);
				Assert.Fail("Exception Expected");
			}
			catch(Exception)
			{
				Assert.IsTrue(true, "Exception Expected");
			}
		}

		[Test]
		public void GetIssueToLocations_Pass()
		{
			DataTable dtTest = DAL.IssuedUnit.GetIssueToLocations();
			
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueToLocationName), TABLES.IssuedUnit.IssueToLocationName);
		}
	
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetIssueToLocations_Fail()
		{
		}

		[Test]
		public void GetPhysicianList_Pass()
		{
			DataTable dtTest = DAL.IssuedUnit.GetPhysicianList();
			
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.PhysicianName), TABLES.IssuedUnit.PhysicianName);
		}
	
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPhysicianList_Fail()
		{
		}

	}
}
#endif



